---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-名前変更 (Rename)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Workspaces/Core/Portable/Rename/Renamer.cs` 1-204行目
- E-02: `src/Workspaces/Core/Portable/Rename/RenameOptions.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 25行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 29行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シンボルの名前を安全に変更 | E-03 | ○ |
| C-02 | 引数バリデーション | E-01 (44-51行目) | ○ |
| C-03 | newNameは空でない文字列が必要 | E-01 (50-51行目) | ○ |
| C-04 | OOP実行を試みる | E-01 (157-177行目) | ○ |
| C-05 | OOP失敗時はローカルにフォールバック | E-01 (175-176行目, 180-182行目) | ○ |
| C-06 | SymbolicRenameLocationsで参照検索 | E-01 (200行目) | ○ |
| C-07 | ConflictResolverで競合解決 | E-01 (201-202行目) | ○ |
| C-08 | 競合解決失敗時はArgumentException | E-01 (63行目) | ○ |
| C-09 | Logger.LogBlockでロギング | E-01 (155行目) | ○ |
| C-10 | SymbolRenameOptionsの構造 | E-02 | ○ |
| C-11 | ドキュメント名変更API | E-01 (97-136行目) | ○ |
| C-12 | RenameDocumentActionの生成 | E-01 (117-118行目) | ○ |
| C-13 | SyncNamespaceDocumentActionの生成 | E-01 (123-124行目) | ○ |
| C-14 | ISpanMappingServiceがある場合はスキップ | E-01 (107-111行目) | ○ |
| C-15 | 処理フローの正確性 | E-01 (全体) | ○ |
| C-16 | 内部APIはConflictResolutionを返却 | E-01 (142-182行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローの記述は正確（ソースコードと一致）
- 0: データ構造の記述は正確
- 0: OOPフォールバックの動作も正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新のソースと一致するか確認
- [ ] ConflictResolver内部の競合解決アルゴリズムの詳細が必要な場合は追加調査
